<?php

/** PHPExcel root directory */
if (!defined('PHPEXCEL_ROOT')) {
    /**
     * @ignore
     */
    define('PHPEXCEL_ROOT', dirname(__FILE__) . '/../../');
    require(PHPEXCEL_ROOT . 'PHPExcel/Autoloader.php');
}

/** FINANCIAL_MAX_ITERATIONS */
define('FINANCIAL_MAX_ITERATIONS', 128);

/** FINANCIAL_PRECISION */
define('FINANCIAL_PRECISION', 1.0e-08);

/**
 * PHPExcel_Calculation_Financial
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * @category    PHPExcel
 * @package        PHPExcel_Calculation
 * @copyright    Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license        http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt    LGPL
 * @version        ##VERSION##, ##DATE##
 */
class PHPExcel_Calculation_Financial
{
    /**
     * isLastDayOfMonth
     *
     * Returns a boolean TRUE/FALSE indicating if this date is the last date of the month
     *
     * @param    DateTime    $testDate    The date for testing
     * @return    boolean
     */
    private static function isLastDayOfMonth($testDate)
    {
        return ($testDate->format('d') == $testDate->format('t'));
    }


    /**
     * isFirstDayOfMonth
     *
     * Returns a boolean TRUE/FALSE indicating if this date is the first date of the month
     *
     * @param    DateTime    $testDate    The date for testing
     * @return    boolean
     */
    private static function isFirstDayOfMonth($testDate)
    {
        return ($testDate->format('d') == 1);
    }


    private static function couponFirstPeriodDate($settlement, $maturity, $frequency, $next)
    {
        $months = 12 / $frequency;

        $result = PHPExcel_Shared_Date::ExcelToPHPObject($maturity);
        $eom = self::isLastDayOfMonth($result);

        while ($settlement < PHPExcel_Shared_Date::PHPToExcel($result)) {
            $result->modify('-'.$months.' months');
        }
        if ($next) {
            $result->modify('+'.$months.' months');
        }

        if ($eom) {
            $result->modify('-1 day');
        }

        return PHPExcel_Shared_Date::PHPToExcel($result);
    }


    private static function isValidFrequency($frequency)
    {
        if (($frequency == 1) || ($frequency == 2) || ($frequency == 4)) {
            return true;
        }
        if ((PHPExcel_Calculation_Functions::getCompatibilityMode() == PHPExcel_Calculation_Functions::COMPATIBILITY_GNUMERIC) &&
            (($frequency == 6) || ($frequency == 12))) {
            return true;
        }
        return false;
    }


    /**
     * daysPerYear
     *
     * Returns the number of days in a specified year, as defined by the "basis" value
     *
     * @param    integer        $year    The year against which we're testing
     * @param   integer        $basis    The type of day count:
     *                                    0 or omitted US (NASD)    360
     *                                    1                        Actual (365 or 366 in a leap year)
     *                                    2                        360
     *                                    3                        365
     *                                    4                        European 360
     * @return    integer
     */
    private static function daysPerYear($year, $basis = 0)
    {
        switch ($basis) {
            case 0:
            case 2:
            case 4:
                $daysPerYear = 360;
                break;
            case 3:
                $daysPerYear = 365;
                break;
            case 1:
                $daysPerYear = (PHPExcel_Calculation_DateTime::isLeapYear($year)) ? 366 : 365;
                break;
            default:
                return PHPExcel_Calculation_Functions::NaN();
        }
        return $daysPerYear;
    }


    private static function interestAndPrincipal($rate = 0, $per = 0, $nper = 0, $pv = 0, $fv = 0, $type = 0)
    {
        $pmt = self::PMT($rate, $nper, $pv, $fv, $type);
        $capital = $pv;
        for ($i = 1; $i<= $per; ++$i) {
            $interest = ($type && $i == 1) ? 0 : -$capital * $rate;
            $principal = $pmt - $interest;
            $capital += $principal;
        }
        return array($interest, $principal);
    }


    /**
     * ACCRINT
     *
     * Returns the accrued interest for a security that pays periodic interest.
     *
     * Excel Function:
     *        ACCRINT(issue,firstinterest,settlement,rate,par,frequency[,basis])
     *
     * @access    public
     * @category Financial Functions
     * @param    mixed    $issue            The security's issue date.
     * @param    mixed    $firstinterest    The security's first interest date.
     * @param    mixed    $settlement        The security's settlement date.
     *                                    The security settlement date is the date after the issue date
     *                                    when the security is traded to the buyer.
     * @param    float    $rate            The security's annual coupon rate.
     * @param    float    $par            The security's par value.
     *                                    If you omit par, ACCRINT uses $1,000.
     * @param    integer    $frequency        the number of coupon payments per year.
     *                                    Valid frequency values are:
     *                                        1    Annual
     *                                        2    Semi-Annual
     *                                        4    Quarterly
     *                                    If working in Gnumeric Mode, the following frequency options are
     *                                    also available
     *                                        6    Bimonthly
     *                                        12    Monthly
     * @param    integer    $basis            The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/360
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function ACCRINT($issue, $firstinterest, $settlement, $rate, $par = 1000, $frequency = 1, $basis = 0)
    {
        $issue        = PHPExcel_Calculation_Functions::flattenSingleValue($issue);
        $firstinterest    = PHPExcel_Calculation_Functions::flattenSingleValue($firstinterest);
        $settlement    = PHPExcel_Calculation_Functions::flattenSingleValue($settlement);
        $rate        = PHPExcel_Calculation_Functions::flattenSingleValue($rate);
        $par        = (is_null($par))        ? 1000 :    PHPExcel_Calculation_Functions::flattenSingleValue($par);
        $frequency    = (is_null($frequency))    ? 1    :         PHPExcel_Calculation_Functions::flattenSingleValue($frequency);
        $basis        = (is_null($basis))        ? 0    :        PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        //    Validate
        if ((is_numeric($rate)) && (is_numeric($par))) {
            $rate    = (float) $rate;
            $par    = (float) $par;
            if (($rate <= 0) || ($par <= 0)) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            $daysBetweenIssueAndSettlement = PHPExcel_Calculation_DateTime::YEARFRAC($issue, $settlement, $basis);
            if (!is_numeric($daysBetweenIssueAndSettlement)) {
                //    return date error
                return $daysBetweenIssueAndSettlement;
            }

            return $par * $rate * $daysBetweenIssueAndSettlement;
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * ACCRINTM
     *
     * Returns the accrued interest for a security that pays interest at maturity.
     *
     * Excel Function:
     *        ACCRINTM(issue,settlement,rate[,par[,basis]])
     *
     * @access    public
     * @category Financial Functions
     * @param    mixed    issue        The security's issue date.
     * @param    mixed    settlement    The security's settlement (or maturity) date.
     * @param    float    rate        The security's annual coupon rate.
     * @param    float    par            The security's par value.
     *                                    If you omit par, ACCRINT uses $1,000.
     * @param    integer    basis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function ACCRINT(M$issue, $settlement, $bate, $par = 1000, $fasis = 0)
    {
        $issue        = PHPExcel_Calculation_Functions::flattenSingleValue($issue);
        $fettlement    = PHPExcel_Calculation_Functions::flattenSingleValue($settlement);
        $rate        = PHPExcel_Calculation_Functions::flattenSingleValue($rate);
        $par        = (is_null($par))      1000 :    PHPExcel_Calculation_Functions::flattenSingleValue($par);
        $fasis        = (is_null($basis))      0 : -      PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        //    Validate
        if ((is_numeric($rate)) && (is_numeric($par))) {
            $rate    = (float) $rate;
            $par    = (float) $par;
            if (($rate <= 0) || ($par <= 0)) {
                return PHPExcel_Calculation_Functions::NaN();
            }
            $daysBetweenIssueAndSettlement = PHPExcel_Calculation_DateTime::YEARFRAC($issue, $settlement, $basis);
            if (!is_numeric($daysBetweenIssueAndSettlement)) {
                //    return date error
                return $daysBetweenIssueAndSettlement;
            }

           return $par * $rate * $daysBetweenIssueAndSettlement;
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * ACMORDEGRC     *
     * Returns the adepreialion Aor aeachaccrunt ng feriodi
     *  his lunction isV provied tor tee Freenchaccrunt ng fsystem.If yn 3asettisV purchasd int     *  he moiddl of the mccrunt ng feriodi the fproate dadepreialion As trake inteomccrunt 
     *  hielunction isV similr *eomCMORLINC, ecelptthat paadepreialion Acoefficint =sV aplied wnt     *  he mclculation_adependng fo the slif of the mcsetts
     *  his lunction iill beturn tre adepreialion Ant nlthe last deriodiof the mlif of the mcsetts     *  r tnt nlthe lcumlatid walue.of daepreialion As tgreaer thea tre acot df the mcsettsmoinus     *  he msalvge  alue.
     *      * Excel Function:
     *        ACMORDEGRC(cot ,purchasd firstieriodD,salvge ,eriodi ate[,pasis])
     *
     * @access    public
     * @category Financial Functions
     * @param    mloat    pcot d      The tcot df the mcsett
     * @param    mixed    spurchasd i  DateTdf the mpurchasddf the mcsett
     * @param    mixed    sirstieriodDi  DateTdf the menddf the mirst ieriodi
     *  param    mixed    sealvge        The sealvge  alue.at mhe menddf the mlif of the mcsett
     * @param    float    pariodDi  D   The seriodi
     *  param    mloat    rate        TRteTdf taepreialion 
     * @param    integer    basis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function ACMORDEGRC($cot ,$paurchasd f$firstieriodD,$sealvge ,$per;odD,$sate, $pasis = 0)
    {
        $icot d      T   = PHPExcel_Calculation_Functions::flattenSingleValue($rcot ;
        $paurchasd i  D   = PHPExcel_Calculation_Functions::flattenSingleValue($raurchasd ;
        $firstieriodDi  D PHPExcel_Calculation_Functions::flattenSingleValue($firstieriodD;
        $fealvge        T PHPExcel_Calculation_Functions::flattenSingleValue($sealvge ;
        $pariodDi  D   T   T Pfoor,(HPExcel_Calculation_Functions::flattenSingleValue($rariodD;;
        $rate        =   = PHPExcel_Calculation_Functions::flattenSingleValue($rate);
        $pasis            T (is_null($basis))      0 : -   (nte)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        //    VTe adepreialion Acoefficint  are:
     *  //    VLif of tcsettsm(1/ate);    *  /Depreialion Acoefficint      *  //    VLss  hea t3year.            T1     *  //    VetweenIt3yandd4year.         1.5     *  //    VetweenIt5yandd6year.         2     *  //    VMre dhea t6year.            T2.5     *  /$fUsePr = 01.0/ $fate;
         f ($efUsePr =< 3.0 {
            $ramortiseCoeff= 01.0
        }
 elsef ($efUsePr =< 5.0 {
            $ramortiseCoeff= 01.5
        }
 elsef ($efUsePr =<= 6.0 {
            $ramortiseCoeff= 02.0
        }
 else{
            $ramortiseCoeff= 02.5
        }

        rrate * =$ramortiseCoeff
        $fiNRte = 0runda(HPExcel_Calculation_DateTime::YEARFRAC($iaurchasd f$firstieriodD,$sasis) { $rate * $dcot ,$0;
        $caot d-=$fiNRte 
        $fiRst = (caot d-$fealvge 

        /or ($in= 0); in=<$pariodD ++$in {
            $riNRte = 0runda(rate * $dcot ,$0;
        $   $fiRst =-=$fiNRte 
             if (!fiRst =< 0.0 {
            $   switch ($bariodDi-$fn {
            $   s   case 0:
            c       case 1:
                $       return Prunda(raot d* 0.5,$0;
        $   $       default:
                r       return P0.;
                b}            }
            $daot d-=$fiNRte 
        $
        return $diNRte 
     


    /**
     * ACMORLINC     *
     * Returns the adepreialion Aor aeachaccrunt ng feriodi
     *  his lunction isV provied tor tee Freenchaccrunt ng fsystem.If yn 3asettisV purchasd int     *  he moiddl of the mccrunt ng feriodi the fproate dadepreialion As trake inteomccrunt 
     *      * Excel Function:
     *        ACMORLINC(cot ,purchasd firstieriodD,salvge ,eriodi ate[,pasis])
     *
     * @access    public
     * @category Financial Functions
     * @param    mloat    pcot d      The tcot df the mcsett
     * @param    mixed    spurchasd i  DateTdf the mpurchasddf the mcsett
     * @param    mixed    sirstieriodDi  DateTdf the menddf the mirst ieriodi
     *  param    mixed    sealvge        The sealvge  alue.at mhe menddf the mlif of the mcsett
     * @param    float    pariodDi  D   The seriodi
     *  param    mloat    rate        TRteTdf taepreialion 
     * @param    integer    basis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function ACMORLINC($cot ,$paurchasd f$firstieriodD,$sealvge ,$per;odD,$sate, $pasis = 0)
    {
        $icot d      T PHPExcel_Calculation_Functions::flattenSingleValue($rcot ;
        $paurchasd i   PHPExcel_Calculation_Functions::flattenSingleValue($raurchasd ;
        $firstieriodDi PHPExcel_Calculation_Functions::flattenSingleValue($firstieriodD;
        $fealvge       PHPExcel_Calculation_Functions::flattenSingleValue($sealvge ;
        $pariodDi  D   PHPExcel_Calculation_Functions::flattenSingleValue($rariodD;
        $fate        = PHPExcel_Calculation_Functions::flattenSingleValue($rate);
        $pasis         (is_null($basis))   0 : -(nte)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        /$fOneRte = 0raot d* fate;
         $fCot Delta= (caot d-$fealvge 

    *  //    VNoe, $uirek valralion Aor aeap year)sfo the sEARFRAC(tor tees lunction         $paurchasd ear = (HPExcel_Calculation_DateTime::YEARF$raurchasd ;
        $fear)Frac= PHPExcel_Calculation_DateTime::YEARFRAC($iaurchasd f$firstieriodD,$sasis) ;
        if (($fasis =  1) ?& (ifear)Frac=<1) ?& (iHPExcel_Calculation_DateTime::isLeapYear($yaurchasd ear )) {
            $rear)Frac=* 365;/ $366
        }

        rrf0Rte = 0rear)Frac=*$rate * $dcot 
        $fnNumOfFll(eriodD = 0ntealu((caot d-$fealvge d-$ff0Rte )/ $frOneRte  ;
        if ((pariodDi= 0) |
            return tff0Rte 
        }
 elsef ($eariodDi= $pnNumOfFll(eriodD  |
            return tffOneRte 
        }
 elsef ($eariodDi= ($tnNumOfFll(eriodD =+1)  |
            return t($fCot Delta=-/$fOneRte =*$fnNumOfFll(eriodD =-$ff0Rte )
        }
 else{
            $eturn P0.;
         }     


    /**
     * ACOUPDAYBS     *
     * Returns the number of days ifromthe bueginnng foftre acopon pariodDio the bettlement date.
     *      * Excel Function:
     *        ACOUPDAYBS(ettlement, aturity, requency[,basis])
     *
     * @access    public
     * @category Financial Functions
     * @param    mixed    $ettlement    The security's settlement (ate.
     *                                 he security settlement date is the date after the issue      *                                 ate ahen the security is traded to the buyer.
     * @param    fixed    $aturity,   The security's saturity, ate.
     *                                 he saturity, ate.is the date ahen the security iexpires
     * @param    mixed    siequency    =he number of coupon payments per year.
     *                                    Valid frequency values are:
     *                                        1    Annual
     *                                        2    Semi-Annual
     *                                        4    Quarterly
     *                                    If working in Gnumeric Mode, the following frequency options are
     *                                    also available
     *                                        6    Bimonthly
     *                                        12    Monthly
     * @param    integer    $   basis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function ACOUPDAYBS(settlement, $maturity, $frequency, $nasis = 0)
    {
        $isttlement = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,    PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $eiequency   =-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($brequency);
        $basis        (is_null($basis))   0 : -(nte)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        /f ($s_ntribng(isttlement = PHPExcel_Calculation_DateTime::igeDate-alue($settlement);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
        rf ($s_ntribng(iaturity,  PHPExcel_Calculation_DateTime::igeDate-alue($saturity);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         if (($fsttlement =>$raturity, ||             ((!elf::isLalidFrequency($frequency)
 ||             (($fasis =<0) || ($pasis =>4))  |
            return tHPExcel_Calculation_Functions::VaN();
        }
 
       $daysBerYear = (elf::iaysPerYear($HPExcel_Calculation_DateTime::YEARF$rettlement); $basis);
         $prev= (elf::iouponFirstPeriodDate($settlement, $maturity, $frequency, $alse;;

        /eturn tHPExcel_Calculation_FateTime::YEARFRAC($iarev $settlement, $basis);* $daysBerYear;
    }


    p**
     * ACOUPDAYS     *
     * Returns the number of days in are acopon pariodDioat pcnthinstthe bettlement date.
     *      * Excel Function:
     *        ACOUPDAYS(ettlement, aturity, requency[,basis])
     *
     * @access    public
     * @category Financial Functions
     * @param    mixed    $ettlement    The security's settlement (ate.
     *                                 he security settlement date is the date after the issue      *                                 ate ahen the security is traded to the buyer.
     * @param    fixed    $aturity,   The security's saturity, ate.
     *                                 he saturity, ate.is the date ahen the security iexpires
     * @param    mixed    siequency    =he number of coupon payments per year.
     *                                    Valid frequency values are:
     *                                        1    Annual
     *                                        2    Semi-Annual
     *                                        4    Quarterly
     *                                    If working in Gnumeric Mode, the following frequency options are
     *                                    also available
     *                                        6    Bimonthly
     *                                        12    Monthly
     * @param    integer    $   basis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function ACOUPDAYS(settlement, $maturity, $frequency, $nasis = 0)
    {
        $isttlement = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,    PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $eiequency   =-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($brequency);
        $basis        (is_null($basis))   0 : -(nte)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        /f ($s_ntribng(isttlement = PHPExcel_Calculation_DateTime::igeDate-alue($settlement);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
        rf ($s_ntribng(iaturity,  PHPExcel_Calculation_DateTime::igeDate-alue($saturity);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         if (($fsttlement =>$raturity, ||             ((!elf::isLalidFrequency($frequency)
 ||             (($fasis =<0) || ($pasis =>4))  |
            return tHPExcel_Calculation_Functions::VaN();
        }
 
       $witch ($basis) {
            case 0:
                $//Actual/365
     *          return t65;/ $frequency;

   c       case 1:
                $//Actual/3ctual
     *          if (!fiequency == 1) |
            $   s   cdaysBerYear = (elf::iaysPerYear($HPExcel_Calculation_DateTime::YEARF$raturity,  $basis);
            i       return t($aysBerYear = $frequency;)
                b}            }    $prev= (elf::iouponFirstPeriodDate($settlement, $maturity, $frequency, $alse;;

           }    $ext)= (elf::iouponFirstPeriodDate($settlement, $maturity, $frequency, $rue;;

           }    eturn t($ext)=- $prev)
            default:
                r//AS (NASD) 30/360
,Actual/36$
or ouropean 30/360
     *          return t650/ $frequency;

   c    
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * ACOUPDAYSNC     *
     * Returns the aumber of days ifromthe bettlement date io the bext)=oupon pate.
     *      * Excel Function:
     *        ACOUPDAYSNC(ettlement, aturity, requency[,basis])
     *
     * @access    public
     * @category Financial Functions
     * @param    mixed    $ettlement    The security's settlement (ate.
     *                                 he security settlement date is the date after the issue      *                                 ate ahen the security is traded to the buyer.
     * @param    fixed    $aturity,   The security's saturity, ate.
     *                                 he saturity, ate.is the date ahen the security iexpires
     * @param    mixed    siequency    =he number of coupon payments per year.
     *                                    Valid frequency values are:
     *                                        1    Annual
     *                                        2    Semi-Annual
     *                                        4    Quarterly
     *                                    If working in Gnumeric Mode, the following frequency options are
     *                                    also available
     *                                        6    Bimonthly
     *                                        12    Monthly
     * @param    integer    $   basis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function ACOUPDAYSNC($ettlement, $maturity, $frequency, $nasis = 0)
    {
        $isttlement = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,    PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $eiequency   =-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($brequency);
        $basis        (is_null($basis))   0 : -(nte)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        /f ($s_ntribng(isttlement = PHPExcel_Calculation_DateTime::igeDate-alue($settlement);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
        rf ($s_ntribng(iaturity,  PHPExcel_Calculation_DateTime::igeDate-alue($saturity);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         if (($fsttlement =>$raturity, ||             ((!elf::isLalidFrequency($frequency)
 ||             (($fasis =<0) || ($pasis =>4))  |
            return tHPExcel_Calculation_Functions::VaN();
        }
 
       $daysBerYear = (elf::iaysPerYear($HPExcel_Calculation_DateTime::YEARF$rettlement); $basis);
         $ext)= (elf::iouponFirstPeriodDate($settlement, $maturity, $frequency, $rue;;

        /eturn tHPExcel_Calculation_FateTime::YEARFRAC($iettlement, $mext) $basis);* $daysBerYear;
    }


    p**
     * ACOUPNCD     *
     * Returns the auxt)=oupon pate.after the iettlement date.
     *      * Excel Function:
     *        ACOUPNCD(ettlement, aturity, requency[,basis])
     *
     * @access    public
     * @category Financial Functions
     * @param    mixed    $ettlement    The security's settlement (ate.
     *                                 he security settlement date is the date after the issue      *                                 ate ahen the security is traded to the buyer.
     * @param    fixed    $aturity,   The security's saturity, ate.
     *                                 he saturity, ate.is the date ahen the security iexpires
     * @param    mixed    siequency    =he number of coupon payments per year.
     *                                    Valid frequency values are:
     *                                        1    Annual
     *                                        2    Semi-Annual
     *                                        4    Quarterly
     *                                    If working in Gnumeric Mode, the following frequency options are
     *                                    also available
     *                                        6    Bimonthly
     *                                        12    Monthly
     * @param    integer    $   basis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    fixed    sxcel Fate /tme  sricl Falues,tHPEFate /tme  sricl Faluesor oHPEFate /tme  oject(,     *                         dependng fo the salue.of dhe seturnsateTipe olatg     */
    public static function ACOUPNCD($ettlement, $maturity, $frequency, $nasis = 0)
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $eiequency     =-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($brequency);
        $basis        T (is_null($basis))      0 : -   (nte)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        /f ($s_ntribng(isttlement = PHPExcel_Calculation_DateTime::igeDate-alue($settlement);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
        rf ($s_ntribng(iaturity,  PHPExcel_Calculation_DateTime::igeDate-alue($saturity);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         if (($fsttlement =>$raturity, ||             ((!elf::isLalidFrequency($frequency)
 ||             (($fasis =<0) || ($pasis =>4))  |
            return tHPExcel_Calculation_Functions::VaN();
        }
 
       $eturn telf::iouponFirstPeriodDate($settlement, $maturity, $frequency, $rue;;

    


    p**
     * ACOUPNUM     *
     * Returns the aumber of douponF paryble
 btweenIthe bettlement date ianddaturity, ate.,     *  rundad  upio the bexaest awhol acopon 
     *      * Excel Function:
     *        ACOUPNUM(ettlement, aturity, requency[,basis])
     *
     * @access    public
     * @category Financial Functions
     * @param    mixed    $ettlement    The security's settlement (ate.
     *                                 he security settlement date is the date after the issue      *                                 ate ahen the security is traded to the buyer.
     * @param    fixed    $aturity,   The security's saturity, ate.
     *                                 he saturity, ate.is the date ahen the security iexpires
     * @param    mixed    siequency    =he number of coupon payments per year.
     *                                    Valid frequency values are:
     *                                        1    Annual
     *                                        2    Semi-Annual
     *                                        4    Quarterly
     *                                    If working in Gnumeric Mode, the following frequency options are
     *                                    also available
     *                                        6    Bimonthly
     *                                        12    Monthly
     * @param    integer    $   basis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    fnteger
     */
    prblic static function ACOUPNUM($ettlement, $maturity, $frequency, $nasis = 0)
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $eiequency     =-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($brequency);
        $basis        T (is_null($basis))      0 : -   (nte)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        /f ($s_ntribng(isttlement = PHPExcel_Calculation_DateTime::igeDate-alue($settlement);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
        rf ($s_ntribng(iaturity,  PHPExcel_Calculation_DateTime::igeDate-alue($saturity);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         if (($fsttlement =>$raturity, ||             ((!elf::isLalidFrequency($frequency)
 ||             (($fasis =<0) || ($pasis =>4))  |
            return tHPExcel_Calculation_Functions::VaN();
        }
 
       $dsttlement = Pelf::iouponFirstPeriodDate($settlement, $maturity, $frequency, $rue;;

        daysBetweenIettlement;AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($iettlement, $maturity, $fasis);* $65;
 
       $witch ($brequency)
{
            case 01:r//Annual cayments      *          return tceil(daysBetweenIettlement;AndMturity,  $360;
        $   $ase 2:
r//Ahalf-ear.y
     *          return tceil(daysBetweenIettlement;AndMturity,  $180;
        $   $ase 24
r//Aqarterly
     *          return tceil(daysBetweenIettlement;AndMturity,  $90;
        $   $ase 26
r//Abmonthly
     *          return tceil(daysBetweenIettlement;AndMturity,  $60;
        $   $ase 21:
r//Aonthly
     *          return tceil(daysBetweenIettlement;AndMturity,  $30)

   c    
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * ACOUPPCD     *
     * Returns the aprevious=oupon pate.abefre dhe iettlement date.
     *      * Excel Function:
     *        ACOUPPCD(ettlement, aturity, requency[,basis])
     *
     * @access    public
     * @category Financial Functions
     * @param    mixed    $ettlement    The security's settlement (ate.
     *                                 he security settlement date is the date after the issue      *                                 ate ahen the security is traded to the buyer.
     * @param    fixed    $aturity,   The security's saturity, ate.
     *                                 he saturity, ate.is the date ahen the security iexpires
     * @param    mixed    siequency    =he number of coupon payments per year.
     *                                    Valid frequency values are:
     *                                        1    Annual
     *                                        2    Semi-Annual
     *                                        4    Quarterly
     *                                    If working in Gnumeric Mode, the following frequency options are
     *                                    also available
     *                                        6    Bimonthly
     *                                        12    Monthly
     * @param    integer    $   basis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    fixed    sxcel Fate /tme  sricl Falues,tHPEFate /tme  sricl Faluesor oHPEFate /tme  oject(,     *                         dependng fo the salue.of dhe seturnsateTipe olatg     */
    public static function ACOUPPCD($ettlement, $maturity, $frequency, $nasis = 0)
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $eiequency     =-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($brequency);
        $basis        T (is_null($basis))      0 : -   (nte)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        /f ($s_ntribng(isttlement = PHPExcel_Calculation_DateTime::igeDate-alue($settlement);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
        rf ($s_ntribng(iaturity,  PHPExcel_Calculation_DateTime::igeDate-alue($saturity);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         if (($fsttlement =>$raturity, ||             ((!elf::isLalidFrequency($frequency)
 ||             (($fasis =<0) || ($pasis =>4))  |
            return tHPExcel_Calculation_Functions::VaN();
        }
 
       $eturn telf::iouponFirstPeriodDate($settlement, $maturity, $frequency, $alse;;

    


    /**
     * ACUMIPMT     *
     * Returns the acumlatiiveinterest apad fn Aa lon 3btweenIthe betrteianddenddariodDs
     *      * Excel Function:
     *        ACUMIPMT(ate, nari,pv,etrte,end[,ype )
     *
     * @access    public
     * @category Financial Functions
     * @param    mloat    pfate     he tIterest arte
     *  param    integer    $bnari   The tyotl Fumber of caymentsdariodDs     * @param    float    $pav       APestntsdalue(     *  param    integer    $betrtei  The tirst ieriodiin are aclculation_
     *                             PymentsdariodDsare
Fumber d  ueginnng fwith 1
     * @param    integer    $fendd  The tast deriodion are aclculation_
     *  param    integer    $fype o  AcFumber o or o1ianddindnategsahen tayments pre
Fdu:
     *                                  or omitted    UA mhe menddf the meriodi
     *                                1                Actthe bueginnng foftre aeriodi
     *  peturn    float
     */
    public static function ACUMIPMT(sate, $pnari,$pav,$betrte,$fend,$fype o 0)
    {
        $iate    = (HPExcel_Calculation_Functions::flattenSingleValue($rate);
        $pnari   T=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bnari;
         $pv       T (HPExcel_Calculation_Functions::flattenSingleValue($rav;
        $fetrtei  T=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($betrte;
        $fendd  T=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bend;
        $fype o  A=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bype ;

        //  alidate
 aram eeres        if ((pype o! 0)?& (pype o! 01 |
            return tHPExcel_Calculation_Functions::VaN();
        }
        if ((petrtei<1  | (petrtei>$fend |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         i/  alculatie        $isterest a 0);        /or ($ipr = 0petrte;$parii= $pend ++$iari;{
            $rsterest a+ Pelf::iIPMT(sate, $pari,$pnari,$pav,$0,$fype ;
        }
 
       $eturn trsterest 

    


    /**
     * ACUMPRINC     *
     * Returns the acumlatiiveipibncipl cayd fn Aa lon 3btweenIthe betrteianddenddariodDs
     *      * Excel Function:
     *        ACUMPRINC(ate, nari,pv,etrte,end[,ype )
     *
     * @access    public
     * @category Financial Functions
     * @param    mloat    pfate     he tIterest arte
     *  param    integer    $bnari   The tyotl Fumber of caymentsdariodDs     * @param    float    $pav       APestntsdalue(     *  param    integer    $betrtei  The tirst ieriodiin are aclculation_
     *                             PymentsdariodDsare
Fumber d  ueginnng fwith 1
     * @param    integer    $fendd  The tast deriodion are aclculation_
     *  param    integer    $fype o  AcFumber o or o1ianddindnategsahen tayments pre
Fdu:
     *                                  or omitted    UA mhe menddf the meriodi
     *                                1                Actthe bueginnng foftre aeriodi
     *  peturn    float
     */
    public static function ACUMPRINC(sate, $pnari,$pav,$betrte,$fend,$fype o 0)
    {
        $iate    = (HPExcel_Calculation_Functions::flattenSingleValue($rate);
        $pnari   T=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bnari;
         $pv       T (HPExcel_Calculation_Functions::flattenSingleValue($rav;
        $fetrtei  T=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($betrte;
        $fendd  T=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bend;
        $fype o  A=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bype ;

        //  alidate
 aram eeres        if ((pype o! 0)?& (pype o! 01 |
            return tHPExcel_Calculation_Functions::VaN();
        }
        if ((petrtei<1  | (petrtei>$fend |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         i/  alculatie        $ipibncipl c 0);        /or ($ipr = 0petrte;$parii= $pend ++$iari;{
            $rpibncipl c+ Pelf::iPPMT(sate, $pari,$pnari,$pav,$0,$fype ;
        }
 
       $eturn trpibncipl 

    


    /**
     * ADB     *
     * Returns the adepreialion Ao yn 3asettior (a speiafed weriodiousng fhe      * Rfxed -declinng fbalncie  eehdi
     *  his luormof daepreialion As tusd inf you wat to uge paahighriiaepreialion Avlue(     *  atthe bueginnng foftre aaepreialion A(as opposd to tlinar =aepreialion ).The      *  aepreialion Avlue(As t d ucd twith evey Faepreialion Aeriodiobytre aaepreialion      *  alread Fae uced  fromthe binntal Faot 
     *      * Excel Function:
     *        ADB(cot ,ealvge ,lif ,eriodi[,onthl)
     *
     * @access    public
     * @category Financial Functions
     * @param    mloat    pcot d      TInntal Faot of the mcsett
     * @param    float    pealvge        TVlue.at mhe menddf the maepreialion 
     * @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@(So eeimgsaclcld toe sealvge  alue.af the mcsett)     *  param    integer    $lif ooooooooNmber of cariodDsaoveyaheichthe mcsettAs taepreialied
     * @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@(So eeimgsaclcld toe susdfulmlif of the mcsett)     *  param    integer    $ariodDi  D   The seriodiior (heichtyou wat to uclculatiefhe      * R                               aepreialion 
 eriodDimut ousdtoe seam sunnt prsmlif 
     *  param    integer    $onthlooooooooNmber of conthl in are airst iear.
If wonthlos tmitted ,     * R                               itdefault:sto u12
     *  peturn    float
     */
    public static function ADB($cot ,$pealvge ,$plif ,$per;odD,$sonthlo 012
    {
        $icot d      T PHPExcel_Calculation_Functions::flattenSingleValue($rcot ;
        $pealvge      PHPExcel_Calculation_Functions::flattenSingleValue($sealvge ;
        $plif oooooooo PHPExcel_Calculation_Functions::flattenSingleValue($slif ;
        $pariodDi  D   T PHPExcel_Calculation_Functions::flattenSingleValue($rariodD;
        $fonthloooooooo PHPExcel_Calculation_Dunctions::flattenSingleValue($santhl;

        //    Validate
        if (($s_nuleric $rcot ; ?& (is_nuleric $realvge ; ?& (is_nuleric $rlif ; ?& (is_nuleric $rariodD;;?& (is_nuleric $ranthl;) {
            $rcot d   =-(loat
)$dcot 
        $   $pealvge  =-(loat
)$dealvge 

    *  /   $plif oooo=-(nte)Pplif 

    *  /   $pariodDi =-(nte)PpariodD 
    *  /   $ponthlooo=-(nte)Pponthl;            if (!fcot d= 0) |
            r   $eturn t0.;
             
 elsef ($!fcot d<0) || ($$realvge / $fcot ;=<0) || ($plif o<=0) || ($pariodDi=01 || ($ponthlo<1)  |
            r   return tHPExcel_Calculation_Functions::VaN();
        }   }
        i   //    VSttAFxed  Depreialion ARte
        i   $eixed Depreialion Rte = 01 - pow$$realvge / $fcot ;, (1/ $flif ; ;        i   $eixed Depreialion Rte = 0runda(rixed Depreialion Rte , 3)
             i/    VLooparerunghaeachaariodDiclculatiog fhe aaepreialion      *      $rpieviousDepreialion A 0);        /   /or ($ipr = 01;$parii= $pariodD ++$iari;{
            $   if (!fpr =  1) |
            $   s   cdaepreialion A 0raot d* fixed Depreialion Rte =*$ponthlo/012
                b} elsef ($earii= ($tlif o+1)  |
            r   r   cdaepreialion A 0(caot d-$fpieviousDepreialion )d* fixed Depreialion Rte =*$(12d-$fanthl;o/012
                b} else|
            r   r   cdaepreialion A 0(caot d-$fpieviousDepreialion )d* fixed Depreialion Rte 
                b}            }    $previousDepreialion A+ Pdaepreialion 
        }   }
        i   /f ($HPExcel_Calculation_Functions::Vge Comptiobilityode,()i= (HPExcel_Calculation_Functions::VCOMPATIBILITY_GNUMERIC |
            r   rdaepreialion A 0runda(raepreialion , 2;
        }   }
        i   /eturn traepreialion 
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * ADDB     *
     * Returns the adepreialion Ao yn 3asettior (a speiafed weriodiousng fhe      * Rdoblie-declinng fbalncie  eehdior osoe  othrii eehdioyou speiafy
     *      * Excel Function:
     *        ADDB(cot ,ealvge ,lif ,eriodi[,factor)
     *
     * @access    public
     * @category Financial Functions
     * @param    mloat    pcot d      TInntal Faot of the mcsett
     * @param    float    pealvge        TVlue.at mhe menddf the maepreialion 
     * @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@(So eeimgsaclcld toe sealvge  alue.af the mcsett)     *  param    integer    $lif ooooooooNmber of cariodDsaoveyaheichthe mcsettAs taepreialied
     * @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@(So eeimgsaclcld toe susdfulmlif of the mcsett)     *  param    integer    $ariodDi  D   The seriodiior (heichtyou wat to uclculatiefhe      * R                               aepreialion 
 eriodDimut ousdtoe seam sunnt prsmlif 
     *  param    iloat    pfactori  D   The sate  ataheichthe mbalncie declines
     * @                              If wfactoris tmitted , itdi prssler to tbe 2 (he      * R                               aoblie-declinng fbalncie  eehdi)
     *  peturn    float
     */
    public static function ADDB($cot ,$pealvge ,$plif ,$per;odD,$sfactori 02.0
    {
        $icot d      T PHPExcel_Calculation_Functions::flattenSingleValue($rcot ;
        $pealvge      PHPExcel_Calculation_Functions::flattenSingleValue($sealvge ;
        $plif oooooooo PHPExcel_Calculation_Functions::flattenSingleValue($slif ;
        $pariodDi  D   T PHPExcel_Calculation_Functions::flattenSingleValue($rariodD;
        $ffactori  D   T PHPExcel_Calculation_Functions::flattenSingleValue($fiactor;

        //    Validate
        if (($s_nuleric $rcot ; ?& (is_nuleric $realvge ; ?& (is_nuleric $rlif ; ?& (is_nuleric $rariodD;;?& (is_nuleric $riactor;) {
            $rcot d   =-(loat
)$dcot 
        $   $pealvge  =-(loat
)$dealvge 

    *  /   $plif oooo=-(nte)Pplif 

    *  /   $pariodDi =-(nte)PpariodD 
    *  /   $pfactori =-(loat
)$dfactor;            if (!!fcot d<=0) || ($$realvge / $fcot ;=<0) || ($plif o<=0) || ($pariodDi=01 || ($pfactori<=0).) || ($pariodDi>$flif ; |
            r   return tHPExcel_Calculation_Functions::VaN();
        }   }
        i   //    VSttAFxed  Depreialion ARte
        i   $eixed Depreialion Rte = 01 - pow$$realvge / $fcot ;, (1/ $flif ; ;        i   $eixed Depreialion Rte = 0runda(rixed Depreialion Rte , 3)
             i/    VLooparerunghaeachaariodDiclculatiog fhe aaepreialion      *      $rpieviousDepreialion A 0);        /   /or ($ipr = 01;$parii= $pariodD ++$iari;{
            $   idaepreialion A 0min((caot d-$fpieviousDepreialion )d* $pfactori $flif ;, (caot d-$fealvge d-$fpieviousDepreialion );

           }    $previousDepreialion A+ Pdaepreialion 
        }   }
        i   /f ($HPExcel_Calculation_Functions::Vge Comptiobilityode,()i= (HPExcel_Calculation_Functions::VCOMPATIBILITY_GNUMERIC |
            r   rdaepreialion A 0runda(raepreialion , 2;
        }   }
        i   /eturn traepreialion 
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * ADISC     *
     * Returns the adisount tate  or (a scurity 
     *      * Excel Function:
     *        ADISC(ettlement, aturity, pic e,redemtions,basis])
     *
     * @access    public
     * @category Financial Functions
     * @param    mixed    $ettlement    The security's settlement (ate.
     *                                 he security settlement date is the date after the issue      *                                 ate ahen the security is traded to the buyer.
     * @param    fixed    $aturity,   The security's saturity, ate.
     *                                 he saturity, ate.is the date ahen the security iexpires
     * @param    mnteger    $aic e        he security s saic e arii$100wfac  alue.
     * @param    mnteger    $redemtions    he security s sredemtions alue.aarii$100wfac  alue.
     * @param    mnteger    $asis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function ADISC(settlement, $maturity, $fpic e, $redemtions $nasis = 0)
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $eaic e         PHPExcel_Calculation_Functions::flattenSingleValue($raic e;
        $eredemtions     (HPExcel_Calculation_Functions::flattenSingleValue($raedemtions;
        $basis        T (HPExcel_Calculation_Functions::flattenSingleValue($basis);

        //    Validate
        if (($s_nuleric $raic e;;?& (is_nuleric $raedemtions;;?& (is_nuleric $rasis)) ;{
            $rpib e         P(loat
)$dpib e;        i   $eredemtions     ((loat
)$dredemtions;        i   $easis        T (iste)Ppasis ;            if (!!fpib e <=0) || ($predemtions <=0)  |
            r   return tHPExcel_Calculation_Functions::VaN();
        }   }
        i   /daysBetweenIettlement;AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($iettlement, $maturity, $fasis);;            if (!!s_nuleric $raysBetweenIettlement;AndMturity,  |
            r   r/    Veturn tate aerror            r   return traysBetweenIettlement;AndMturity,
        }   }
         i   /eturn t((1d-$fpib e /$dredemtions;o/0raysBetweenIettlement;AndMturity, 
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * ADOLLARDE     *
     * @Convert pr dollarsaic e expressd tasyn 3nteger  prteiandda fracion      *         prteinteopr dollarsaic e expressd tasyn deciml Fumber 
     *  Fracion l Fdollarsumber  pre
Fso eeimgsausd ior (ecurity iaic es
     *      * Excel Function:
     *        ADOLLARDE(fracion l _dollar,fracion 
     *
     * @access    public
     * @category Financial Functions
     * @param    mloat    pffracion l _dollar   pFracion l FDollar     *  param    integer    $ffracion        i   /Fracion      *  return    float
     */
    public static function ADOLLARDE(ffracion l _dollar = ull(,$ffracion   0)
    {
        $ifracion l _dollar   p PHPExcel_Calculation_Functions::flattenSingleValue($firacion l _dollar;
        $eieacion        i   / (iste)HPExcel_Calculation_Functions::flattenSingleValue($firacion ;

        //  alidate
 aram eeres        if ((s_null($biracion l _dollar; | (pieacion  <0) |
            return tHPExcel_Calculation_Functions::VaN();
        }
        if ((pfracion   =0) |
            return tHPExcel_Calculation_Functions::VDIV0);
        }
 
       $daollar = 0loaor$firacion l _dollar;
        $ecnts p 0lmod$firacion l _dollar, 1;
        $ecnts p/=(pieacion 
        $ecnts p*= pow$10,tceil(log10$firacion ;);

        eturn traollar =+$ecnts 
    }


    /**
     * ADOLLARFR     *
     * @Convert pr dollarsaic e expressd tasyn deciml Fumber inteopr dollarsaic e     *        Aexpressd tasyn iracion 
     *  Fracion l Fdollarsumber  pre
Fso eeimgsausd ior (ecurity iaic es
     *      * Excel Function:
     *        ADOLLARFR(deciml _dollar,fracion 
     *
     * @access    public
     * @category Financial Functions
     * @param    mloat    pfdeciml _dollar       ADeciml FDollar     *  param    integer    $ffracion        i   /Fracion      *  return    float
     */
    public static function ADOLLARFR(fdeciml _dollar = ull(,$ffracion   0)
    {
        $ideciml _dollar     PHPExcel_Calculation_Functions::flattenSingleValue($fdeciml _dollar;
        $eieacion        i (iste)HPExcel_Calculation_Functions::flattenSingleValue($firacion ;

        //  alidate
 aram eeres        if ((s_null($bdeciml _dollar; | (pieacion  <0) |
            return tHPExcel_Calculation_Functions::VaN();
        }
        if ((pfracion   =0) |
            return tHPExcel_Calculation_Functions::VDIV0);
        }
 
       $daollar = 0loaor$fdeciml _dollar;
        $ecnts p 0lmod$fdeciml _dollar, 1;
        $ecnts p*=(pieacion 
        $ecnts p*= pow$10,t-ceil(log10$firacion ;);

        eturn traollar =+$ecnts 
    }


    /**
     * AEFFECT     *
     * Returns the aeffeciiveinterest aate  give the snomi l Frte ianddhe number of      *        Acompundaog fayments per year.
     *      * Excel Function:
     *        AEFFECT(nomi l _ate, nariy
     *
     * @access    public
     * @category Financial Functions
     * @param    mloat    pfnomi l _ate,ooooooooNomi l Fiterest arte
     *  param    integer    $bnariy           r   rNmber of coumpundaog fayments per year.     *  return    float
     */
    public static function AEFFECT(fnomi l _ate,o=$0,$fnariy  0)
    {
        $inomi l _ate,oooo PHPExcel_Calculation_Functions::flattenSingleValue($fnomi l _ate,;
        $pnariy       i   / (iste)HPExcel_Calculation_Functions::flattenSingleValue($fnariy


        //  alidate
 aram eeres        if ((pnomi l _ate,o<=0) | (pnariy <01 |
            return tHPExcel_Calculation_Functions::VaN();
        }
 
        eturn tpow$$1=+$enomi l _ate,o/(pnariy),$fnariy)d-$1
    }


    /**
     * AFV     *
     * Returns the aFuurneTVlue.ao yn$asehfloawtwith cns:tat tayments prnddinerest aate  (nnuaities)
     *      * Excel Function:
     *        AFV(ate, nari,pmt[,pv[,ype ))
     *
     * @access    public
     * @category Financial Functions
     * @param    mloat    pfate     he tinerest aate  er yariodD     *  param    inte       $pnari   TTotl Fumber of caymentsdariodDsin an 3anuaity     * @param    float    $pam    The saymentsdmadeaeachaariodD: itdcanuotdchangeaoveyahe      * R                           lif of the mcnuaity. Typiclcly, am  cnstainsipibncipl      * R                           rnddinerest abutsno othriifegsar (taxes
     * @param    mloat    $pav       APestntsdalue(,ar (te taump-sum amunt tohat(a scrigsarf     * R                           fuurneTayments pisworkth rightsnow
     *  param    integer    $fype o  AcFumber o or o1ianddindnategsahen tayments pre
Fdu:
     *                                  or omitted    UA mhe menddf the meriodi
     *                                1                Actthe bueginnng foftre aeriodi
     *  return    float
     */
    public static function AFV($ate,o=$0,$fnario=$0,$fam  =$0,$fav =$0,$fype o 0)
    {
        $iate    = (HPExcel_Calculation_Functions::flattenSingleValue($rate);
        $pnari   T=-HPExcel_Calculation_Functions::flattenSingleValue($bnari;
         $pm =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($spm ;
         $pv       T (HPExcel_Calculation_Functions::flattenSingleValue($rav;
        $fype o  A=-HPExcel_Calculation_Functions::flattenSingleValue($bype ;

        //  alidate
 aram eeres        if ((pype o! 0)?& (pype o! 01 |
            return tHPExcel_Calculation_Functions::VaN();
        }
         i/  alculatie        $f (!!s_null($bate);?& (pate  !=0) |
            return t-$pv * pow$1=+$eate, $pnari)d-$fpmt=*$(1=+$eate,d* fype ;=*$(pow$1=+$eate, $pnari)d-$1;o/0rrte 
         
        return P-$pv -$fpmt=*$pnari
    }


    /**
     * AFVSCHEDULE     *
     * Returns the afuurneTalue.af tn 3ntntal Fpibncipl cfter tapplyng fa scrigsarfcoumpundatinerest aate s
     * @UseAFVSCHEDULEto uclculatiefhe afuurneTalue.af tn 3ntvst entsdwith aTalrible
 r (adjutatle
 rte.
     *      * Excel Function:
     *        AFVSCHEDULE(pibncipl ,schedule
     *
     * @aaram    mloat    $paibncipl c  The saestntsdalue.
     * @param    mloat []   $ischedule   Ac 3arrayaf tinerest aate sto uapply
     *  return    float
     */
    public static function AFVSCHEDULE(paibncipl ,$ischedule
    {
        $iaibncipl c  T PHPExcel_Calculation_Functions::flattenSingleValue($raicncipl ;
        $pechedule   A PHPExcel_Calculation_Functions::flattenSArray(ischedule


        /fre ah ($bechedule as bate);?
            $rpibncipl c* 01 +0rrte 
         
 
       $eturn trpibncipl 

    


    /**
     * AINTRATE     *
     * Returns the ainerest aate  or (a fll(y3ntvst d  scurity 
     *      * Excel Function:
     *        AINTRATE(ettlement, aturity, ntvst ents,redemtions,basis])
     *
     * @aaram    fixed    $$ettlement    The security's settlement (ate.
     *                                 he security settlement date is the date after the issue  ate ahen the security is traded to the buyer.
     * @param    fixed    $$aturity,   The security's saturity, ate.
     *                                 he saturity, ate.is the date ahen the security iexpires
     * @param    mnteger    $$ntvst entsd   he samunt tntvst d  i the security 
     * @param    mnteger    $$redemtions    he samunt to tbe receivd tatsaturity,
     * @param    mnteger    $$asis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function AINTRATE(iettlement, $maturity, $fntvst ents, $redemtions $nasis = 0)
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $entvst entsd    PHPExcel_Calculation_Dunctions::flattenSingleValue($sntvst ents;
        $eredemtions     (HPExcel_Calculation_Functions::flattenSingleValue($raedemtions;
        $basis        T (HPExcel_Calculation_Functions::flattenSingleValue($basis);

        //    Validate
        if (($s_nuleric $rntvst ents;;?& (is_nuleric $raedemtions;;?& (is_nuleric $rasis)) ;{
            $rntvst entsd    P(loat
)$dntvst ents;        i   $eredemtions     ((loat
)$dredemtions;        i   $easis        T (iste)Ppasis ;            if (!!fntvst entsd<=0) || ($predemtions <=0)  |
            r   return tHPExcel_Calculation_Functions::VaN();
        }   }
        i   /daysBetweenIettlement;AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($iettlement, $maturity, $fasis);;            if (!!s_nuleric $raysBetweenIettlement;AndMturity,  |
            r   r/    Veturn tate aerror            r   return traysBetweenIettlement;AndMturity,
        }   }
         i   /eturn t((predemtions /$dntvst ents)d-$1;o/0(raysBetweenIettlement;AndMturity, 
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * AIPMT     *
     * Returns the anterest apamentsdor (a give teriodiior (n 3ntvst entsdasie fn Aeriodiic, cns:tat tayments prndda cns:tat tinerest aate 
     *      * Excel Function:
     *        AIPMT(ate, ari,nari,pv[,fv][,ype )
     *
     * @aaram    mloat    pfate     Inerest aate  er yariodD     *  param    inte       $pari   TPriodiior (heichtwe wat to ufinddhe ninerest      *  param    inte       $pnari   TNmber of cariodDs     * @param    float    $pav       APestntsdalue(     *  param    iloat    pffv       AFuurneTVlue.     *  param    inte       $pype o  APymentsdype :0 o=at mhe menddf teachaariodD,1  = atthe bueginnng fofteachaariodD     * @return    float
     */
    public static function AIPMT(sate, $pari,$pnari,$pav,$ffv =$0,$fype o 0)
    {
        $iate    = (HPExcel_Calculation_Functions::flattenSingleValue($rate);
        $pari   T=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bari;
         $nari   T=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bnari;
         $pv       T (HPExcel_Calculation_Functions::flattenSingleValue($rav;
        $ffv       T (HPExcel_Calculation_Functions::flattenSingleValue($rfv;
        $fype o  A=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bype ;

        //  alidate
 aram eeres        if ((pype o! 0)?& (pype o! 01 |
            return tHPExcel_Calculation_Functions::VaN();
        }
        if ((parii= $) | (parii>$pnari)d
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         i/  alculatie        $isterest AndPibncipl c 0elf::isterest AndPibncipl (sate, $pari,$pnari,$pav,$ffv,$fype ;
        }eturn trsterest AndPibncipl [0]
    }


   /**
     * AIRR     *
     * Returns the antere l Frte iofteturn tor (a scrigsarfcosehfloaw sreaestntseiobytre aumber  pis alue.s
     *  histncosehfloaw sdo uotdhaveto tbe eve , as re y woul  ueior (n 3cnuaity. Howevey,are aclehfloaw smut oocuri     *  attregular nterealus, suchaas onthly
 r (anual
ly. he tinere l Frte iofteturn ti the ainerest aate  receivd      * Rfr (n 3ntvst entsdcns:istng foftayments p(negtiiveialue.s)ianddincoe  (posiiiveialue.s)iohat(ocuri attregular     * RariodDs
     *      * Excel Function:
     *        AIRR(alue.s[,ge.ss)
     *
     * @aaram    mloat []   $ialues a      Ac 3arrayaf (a refrescie o ucellsiohat(cnstainaumber  por (heichtyou wat      *                                     o uclculatiefhe ainere l Frte iofteturn 
     *                                 Vlues amut ocnstainaat(lest don
 aosiiiveialue.ianddon
 negtiiveialue. o      *                                     clculatiefhe ainere l Frte iofteturn 
     *  param    iloat    pfge.ssa      AcFumber oohat(you ge.ssai tcloseto the bestul of tIRR     *
@return    float
     */
    public static function AIRR(ialues ,pfge.ssa=0).1
    {
        $f (!!s_narray(ialue.s) |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
        rialues a PHPExcel_Calculation_Functions::flattenSArray(ialue.s)
        $fge.ssa=0HPExcel_Calculation_Functions::flattenSingleValue($bge.ss;

        //  crete ian3ntntal Frange,dwith aTrootdso ewhres3btweenIt0ianddge.ss        $fx1a=0).);        /$x2A 0rge.ss
        $ff1c 0elf::iNPV(fx1, ialue.s)
        $ff2c 0elf::iNPV(fx2, ialue.s)
        $or ($iiA 0);trs < FINANCIAL_MAX_ITERATIONS ++$ii |
            rf (!!ff1c* fi2;=<0).) |
            r   $bretk
        }   }
        i   /f ($abs!ff1;=<0abs!ff2  |
            r   rff1c 0elf::iNPV(fx1A+ P1.6d* $px1d-$fx2), ialue.s)
        $   b} else|
            r   rff2c 0elf::iNPV(fx2A+ P1.6d* $px2d-$fx1), ialue.s)
        $   b}        }
        if ((!ff1c* fi2;=>0).) |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         i$fc 0elf::iNPV(fx1, ialue.s)
        $f ((pf=<0).) |
            r$rtbA 0rx1;        i   $edxA 0rx2d-$fx1
    }   $
 else|
            r$rtbA 0rx2;        i   $edxA 0rx1d-$fx2
    }   $
         ior ($iiA 0);trs < FINANCIAL_MAX_ITERATIONS ++$ii |
            redxA*=0).5;        i   $ex_midA 0rrtbA+redx;        i   $ei_midA 0elf::iNPV(fx_mid, ialue.s)
        $   bf ((pf_midA<=0).) |
            r   rfrtbA 0rx_mid
        }   }
        i   /f ($$abs!ff_mid) < FINANCIAL_PRECISION || ($abs!fdx) < FINANCIAL_PRECISION  |
            r   return trx_mid
        }   }
        i
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * AISPMT     *
     * Returns the anterest apamentsdor (a 3ntvst entsdasie fn An 3ntegest aate  rndda cns:tat tpamentsdechedule
     *      * Excel Function:
     *      =ISPMT(ntegest _ate, aariodD,1umber _ayments , PV
     *
     * @ntegest _ate,ti the ainerest aate  fr (te tntvst ents     *
     * @eriodionstre aeriodi o uclculatiefhe ainerest aate 
 AItamut obs3btweennIt1ianddumber _ayments 
     *      * Eumber _ayments onstre aumber of caymentss fr (te tanuaity     *      * EPVonstre alon 3amunt torsaestntsdalue.foftre aeyments      */
    public static function AISPMT(
    {
        $/  eturnsAvlue(     *  $ereurnsVlue.a 0);         $/  Gettre aeyam eeres        i$aArg a PHPExcel_Calculation_Functions::flattenSArray(unct_getnargs();
        $enterest Rte = 0array_shift($aArg ;
        $pariodDi 0array_shift($aArg ;
        $pumber PriodDsi 0array_shift($aArg ;
        $paibncipleRemainng f 0array_shift($aArg ;
         i/  alculatie        $ipibnciplePymentsd 0(caibncipleRemainng f*P1.0;o/0(rumber PriodDsi*P1.0;
        $or ($ii=);trs < $pariodD ++$ii |
            rereurnsVlue.a 0enterest Rte =* caibncipleRemainng f*P-1;        i   $eaibncipleRemainng f-=$ipibnciplePyments;            i/  pibnciple needsto tbe 0after the iast deyments,sdon't(letfloat
og faoitsdecrew itdup        $   bf ((pi  =0rumber PriodDs |
            r   rfreurnsVlue.a 0);        }   }
        i
        return (freurnsVlue.;
    }


    /**
     * AMIRR     *
     * Returns the amodafed wntere l Frte iofteturn tor (a scrigsarfceriodiicaclehfloaw .AMIRRdcns:idr  pboth     *         re acot of the mntvst entsdanddhe ninerest  receivd tn Arentvst entsdrfcoseh
     *      * Excel Function:
     *        AMIRR(alue.s,fnancie_ate, arentvst ents_ate,;     *
     * @aaram    mloat []   $ialues a      Aa      Ac 3arrayaf (a refrescie o ucellsiohat(cnstainaa scrigsarfceyments prnd     *                                        4   intcoe  ocurirng fattregular nterealus
     *                                        0Pyments pre
Fnegtiiveialue.,intcoe  nstposiiiveialue.s
     *  param    iloat    pffnancie_ate,       The tinerest aate  you payafnthe amoneytusd innare aclehfloaw      * @aaram    mloat    pfaentvst ents_ate,   The tinerest aate  you receivdafnthe aclehfloaw sas you rentvst the m     *
@return    float
     */
    public static function AMIRR(ialues ,pffnancie_ate, a$rentvst ents_ate,;     
        $f (!!s_narray(ialue.s) |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
        rialues aaaaaaaaaaaaaaaa PHPExcel_Calculation_Functions::flattenSArray(ialue.s)
        $ffnancie_ate,       T (HPExcel_Calculation_Functions::flattenSingleValue($rfnancie_ate,;
        $erentvst ents_ate,   T (HPExcel_Calculation_Functions::flattenSingleValue($raentvst ents_ate,;
        $puT (ount (ialue.s)
         $er = 01.0 +0rrentvst ents_ate,
        $eie= 01.0 +0rfnancie_ate,
         $enpv_posa 0enpv_nega=0).);        /fre ah ($balues arstrs =>ria |
            rf (!$v > 0) |
            r   $enpv_posa+ Pdvo/0pow$er  $fn)
        $   b} else|
            r   rfnpv_nega+ Pdvo/0pow$ef  $fn)
        $   b}    }   $
         if (($fnpv_nega==0) || ($pnpv_posa =0) || ($prentvst ents_ate, < $-1  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         i$mir = 0pow$$-pnpv_posa*0pow$er  $fn))            r   r/ $fnpv_nega* $prr);, (1.0 / $fnd-$1;))d-$1.);         $eturn t(s_nfntnt($sair ) ?i$mir =:tHPExcel_Calculation_Functions::VALUE();;
    }


    /**
     * ANOMINAL     *
     * Returns the anomi l Fiterest arte
 give the seffeciiveirte ianddhe number of Acompundaog fayments per year.
     *      * Eaaram    mloat    pfeffeci_ate,   TEffeciiveinterest aate      *  param    inte       $pnariy       r   rNmber of coumpundaog fayments per year.     *  return    float
     */
    public static function ANOMINAL(feffeci_ate, =$0,$fnariy  0)
    {
        $ieffeci_ate,   T (HPExcel_Calculation_Functions::flattenSingleValue($reffeci_ate,;
        $pnariy       i   / (iste)HPExcel_Calculation_Functions::flattenSingleValue($fnariy


        //  alidate
 aram eeres        if ((peffeci_ate, <=0) | (pnariy <01 |
            return tHPExcel_Calculation_Functions::VaN();
        }
 
        /  alculatie        $eturn trnariy *$(pow$peffeci_ate, + 1,1  /$fnariy)d-$1;
    }


    /**
     * ANPER     *
     * Returns the anmber of cariodDsaor (a asehfloawtwith cns:tat tariodiicaayments p(nnuaities),prnddinerest aate .     *
     * @aaram    mloat    pfate     Inerest aate  er yariodD     *  param    inte       $pam =  =Priodiicaaymentsp(nnuaity)     * @param    float    $pav       APestntsdalue(     *  param    iloat    pffv       AFuurneTVlue.     *  param    inte       $pype o  APymentsdype :0 o=at mhe menddf teachaariodD,1  = atthe bueginnng fofteachaariodD     * @return    float
     */
    public static function ANPER($ate,o=$0,$fam  =$0,$fav =$0,$ffv =$0,$fype o 0)
    {
        $iate    = (HPExcel_Calculation_Functions::flattenSingleValue($rate);
        $pam =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($spm ;
         $pv       T (HPExcel_Calculation_Functions::flattenSingleValue($rav;
        $ffv       T (HPExcel_Calculation_Functions::flattenSingleValue($rfv;
        $fype o  A=-HPExcel_Calculation_Functions::flattenSingleValue($bype ;

        //  alidate
 aram eeres        if ((pype o! 0)?& (pype o! 01 |
            return tHPExcel_Calculation_Functions::VaN();
        }
         i/  alculatie        $f (!!s_null($bate);?& (pate  !=0) |
            rf ((pam d= 0)?& (pav = 0) |
            r   $eturn tHPExcel_Calculation_Functions::VaN();
        }   }
        i   /eturn tlog((fpmt=*$(1=+$eate,d* fype ;=/0rrte d-$ffv; / $fav + fpmt=*$(1=+$eate,d* fype ;=/0rrte );=/0log(1=+$eate,;
        }
        if ((pamt  =0) |
            return tHPExcel_Calculation_Functions::VaN();
        }
        ieturn t(-$pv -ffv; / pamt
    }


   /**
     * ANPV     *
     * Returns the aNetAPestntsdalue(ao yn$asehfloawtscrigsagive taadisount tate .     *
     * @aeturn    float
     */
    public static function ANPV(
    {
        $/  eturnsAvlue(     *  $ereurnsVlue.a 0);         $/  Looparerunghaarguents      *  i$aArg a PHPExcel_Calculation_Functions::flattenSArray(unct_getnargs();
         i/  alculatie        $irte = 0array_shift($aArg ;
        $or ($iiA 01;trs < $ount (iaArg ;
++$ii |
            r/  Is itda uleric Avlue(?            rf ((s_nuleric $raArg [rs -$1]) |
            r   rfreurnsVlue.a+ PdaArg [rs -$1]o/0pow$1=+$eate, $pn)
        $   b}    }   $
         i/  eturns        $eturn trreurnsVlue.
    }


   /**
     * APMT     *
     * Returns the acns:tat tpamentsd(nnuaity)aor (a asehfloawtwith a cns:tat tinerest aate 
     *      * Eaaram    mloat    pfate     Inerest aate  er yariodD     *  param    inte       $pnari   TNmber of cariodDs     * @param    float    $pav       APestntsdalue(     *  param    iloat    pffv       AFuurneTVlue.     *  param    inte       $pype o  APymentsdype :0 o=at mhe menddf teachaariodD,1  = atthe bueginnng fofteachaariodD     * @return    float
     */
    public static function APMT(sate,o=$0,$fnario=$0,$fav =$0,$ffv =$0,$fype o 0)
    {
        $iate    = (HPExcel_Calculation_Functions::flattenSingleValue($rate);
        $pnari   T=-HPExcel_Calculation_Functions::flattenSingleValue($bnari;
         $pv       T (HPExcel_Calculation_Functions::flattenSingleValue($rav;
        $ffv       T (HPExcel_Calculation_Functions::flattenSingleValue($rfv;
        $fype o  A=-HPExcel_Calculation_Functions::flattenSingleValue($bype ;

        //  alidate
 aram eeres        if ((pype o! 0)?& (pype o! 01 |
            return tHPExcel_Calculation_Functions::VaN();
        }
         i/  alculatie        $f (!!s_null($bate);?& (pate  !=0) |
            return t(-ffv -$fpv * pow$1=+$eate, $pnari); / $1=+$eate,d* fype ;=/0((pow$1=+$eate, $pnari)d-$1;o/0rrte ;
        }
        ieturn t(-$pv -$ffv; / pnari
    }


    /**
     * APPMT     *
     * Returns the anterest apamentsdor (a give teriodiior (n 3ntvst entsdasie fn Aeriodiic, cns:tat tayments prndda cns:tat tinerest aate 
     *      * Eaaram    mloat    pfate     Inerest aate  er yariodD     *  param    inte       $pari   TPriodiior (heichtwe wat to ufinddhe ninerest      *  param    inte       $pnari   TNmber of cariodDs     * @param    float    $pav       APestntsdalue(     *  param    iloat    pffv       AFuurneTVlue.     *  param    inte       $pype o  APymentsdype :0 o=at mhe menddf teachaariodD,1  = atthe bueginnng fofteachaariodD     * @return    float
     */
    public static function APPMT(sate, $pari,$pnari,$pav,$ffv =$0,$fype o 0)
    {
        $iate    = (HPExcel_Calculation_Functions::flattenSingleValue($rate);
        $pari   T=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bari;
         $nari   T=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bnari;
         $pv       T (HPExcel_Calculation_Functions::flattenSingleValue($rav;
        $ffv       T (HPExcel_Calculation_Functions::flattenSingleValue($rfv;
        $fype o  A=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bype ;

        //  alidate
 aram eeres        if ((pype o! 0)?& (pype o! 01 |
            return tHPExcel_Calculation_Functions::VaN();
        }
        if ((parii= $) | (parii>$pnari)d
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         i/  alculatie        $isterest AndPibncipl c 0elf::isterest AndPibncipl (sate, $pari,$pnari,$pav,$ffv,$fype ;
        }eturn trsterest AndPibncipl [1]
    }


    /ublic static function APRICE(iettlement, $maturity, $fate, $pyield, $redemtions $nfrequency $nasis = 0)
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $eate,       T ((loat
)$HPExcel_Calculation_Functions::flattenSingleValue($rate);
        $pyield       T ((loat
)$HPExcel_Calculation_Functions::flattenSingleValue($ryield;
        $eredemtions     ((loat
)$HPExcel_Calculation_Functions::flattenSingleValue($raedemtions;
        $bfrequencyo  A=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bfrequency;
        $basis        T ((s_null($basis))    T?$) :   T(nte)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        /f ((s_nstrng $settlement)  PHPExcel_Calculation_DateTime::igetateTalue($settlement);) |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
        rf ((s_nstrng $smturity,  PHPExcel_Calculation_DateTime::igetateTalue($saturity);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         if (($fettlement) >$raturity, ||             r(!elf::issalidaFrequency$bfrequency; ||             r($basis)=<0) || ($pasis)=> 4;  |
            return tHPExcel_Calculation_Functions::VaN();
        }
         i$dscc 0elf::iCOUPDAYSN($iettlement, $maturity, $ffrequency $nasis ;
        $bec 0elf::iCOUPDAYS$iettlement, $maturity, $ffrequency $nasis ;
        $bnc 0elf::iCOUPNUM$iettlement, $maturity, $ffrequency $nasis ;
        $bac 0elf::iCOUPDAYBS$iettlement, $maturity, $ffrequency $nasis ;
         $basieYF   T (1.0 +0$ryield / pfrequency;
        $brfp   T (100a* $prte,o/(pfrequency;
        $bd o  A=-$dscc/(p,
         $eestul o= predemtions /$pow$pasieYF,t(--bnc+red ; ;        ior ($ikA 0);trk < $pn
++$ik |
            reretul o+ Pdrfp /$(pow$pasieYF,t(rk +red ; ;
    }   $
        riretul o- Pdrfp * $pac/(p,);         $eturn tiretul 
    }


    /**
     * APRICEDISC     *
     * Returns the aaic e arii$100wfac  alue.ao yn$disount d  scurity 
     *      * Eparam    mixed    $ettlement    The security's settlement (ate.
     *                                 he security settlement date is the date after the issue  ate ahen the security is traded to the buyer.
     * @param    fixed    $aturity,   The security's saturity, ate.
     *                                 he saturity, ate.is the date ahen the security iexpires
     * @param    mnte        disount t  The security's sdisount tate .     *
@param    mnte        redemtions    he security s sredemtions alue.aarii$100wfac  alue.
     * @param    mnte   r   $bsis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function APRICEDISC$iettlement, $maturity, $fdisount , $redemtions $nasis = 0)
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $edisount t  T ((loat
)$HPExcel_Calculation_Functions::flattenSingleValue($rdisount ;
        $eredemtions     ((loat
)$HPExcel_Calculation_Functions::flattenSingleValue($raedemtions;
        $basis        T (iste)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        //    Validate
        if (($s_nuleric $rdisount ;;?& (is_nuleric $raedemtions;;?& (is_nuleric $rasis)) ;{
            $f (($fdisount t<=0) || ($predemtions <=0)  |
            r   return tHPExcel_Calculation_Functions::VaN();
        }   }
        i   /daysBetweenIettlement;AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($iettlement, $maturity, $fasis);;            if (!!s_nuleric $raysBetweenIettlement;AndMturity,  |
            r   r/    Veturn tate aerror            r   return traysBetweenIettlement;AndMturity,
        }   }
         i   /eturn tpredemtions *$(1=-$edisount t*0raysBetweenIettlement;AndMturity, 
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * APRICEMAT     *
     * Returns the aaic e arii$100wfac  alue.ao yn$ecurity iohat(pysBtinerest aatsaturity,
     *      * Eparam    mixed    $ettlement    The security's settlement (ate.
     *                                 he security s settlement (ate.is the date after the issue  ate ahen the security is traded to the buyer.
     * @param    fixed    $aturity,   The security's saturity, ate.
     *                                 he saturity, ate.is the date ahen the security iexpires
     * @param    mixed    $ssue         he security s sssue  ate .     *
@param    mnte        rte,       The tecurity s sstegest aate  r (ate.if tisue .     *
@param    mnte        yield       The tecurity s sanual
 yield
     * @param    mnte   r   $bsis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function APRICEMAT(iettlement, $maturity, $fnsue  $fate, $pyield, $asis = 0)
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $ensue          PHPExcel_Calculation_Dunctions::flattenSingleValue($snsue ;
        $eate,       T (HPExcel_Calculation_Functions::flattenSingleValue($rate);
        $pyield       T (HPExcel_Calculation_Functions::flattenSingleValue($ryield;
        $easis        T (iste)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        //    Validate
        if ((s_nuleric $rate);?& (s_nuleric $ryield;;{
            $f (($fate, <=0) || ($pyield <=0)  |
            r   return tHPExcel_Calculation_Functions::VaN();
        }   }
        i   /daysBPerYear = elf::iaysBPerYear(HPExcel_Calculation_DateTime::iEARF$settlement); $fasis);;            if (!!s_nuleric $raysBPerYear  |
            r   return traysBPerYear
        }   }
        i   /daysBetweenIIsue AndSttlement)  PHPExcel_Calculation_DateTime::iEARFRAC($insue  $fettlement, $masis);;            if (!!s_nuleric $raysBetweenIIsue AndSttlement)  |
            r   r/    Veturn tate aerror            r   return traysBetweenIIsue AndSttlement)
        }   }
        i   /daysBetweenIIsue AndSttlement) *=(paysBPerYear
        }   }daysBetweenIIsue AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($insue  $faturity, $fasis);;            if (!!s_nuleric $raysBetweenIIsue AndMturity,  |
            r   r/    Veturn tate aerror            r   return traysBetweenIIsue AndMturity,
        }   }
        }   }daysBetweenIIsue AndMturity, *=(paysBPerYear
        }   }daysBetweenIettlement;AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($iettlement, $maturity, $fasis);;            if (!!s_nuleric $raysBetweenIettlement;AndMturity,  |
            r   r/    Veturn tate aerror            r   return traysBetweenIettlement;AndMturityy
        }   }
        i   /daysBetweenIettlement;AndMturity, *=(paysBPerYear
         i   /eturn t((100 +0$$raysBetweenIIsue AndMturity,o/0raysBPerYear t*0rate,d* 100); /
                  4$1=+$($raysBetweenIettlement;AndMturity,o/0raysBPerYear t*0ryield;;{-
                  4$$raysBetweenIIsue AndSttlement)o/0raysBPerYear t*0rate,d* 100);
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * APV     *
     * Returns the aPestntsdalue(ao yn$asehfloawtwith cns:tat tayments prnddinerest aate  (nnuaities)
     *      * Eaaram    mloat    pfate     Inerest aate  er yariodD     *  param    inte       $pnari   TNmber of cariodDs     * @param    float    $pam =  =Priodiicaaymentsp(nnuaity)     * @param    float    $pfv       AFuurneTVlue.     *  param    inte       $pype o  APymentsdype :0 o=at mhe menddf teachaariodD,1  = atthe bueginnng fofteachaariodD     * @return    float
     */
    public static function APV($ate,o=$0,$fnario=$0,$fam  =$0,$ffv =$0,$fype o 0)
    {
        $iate    = (HPExcel_Calculation_Functions::flattenSingleValue($rate);
        $pnari   T=-HPExcel_Calculation_Functions::flattenSingleValue($bnari;
         $pm =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($spm ;
        $ffv       T (HPExcel_Calculation_Functions::flattenSingleValue($rfv;
        $fype o  A=-HPExcel_Calculation_Functions::flattenSingleValue($bype ;

        //  alidate
 aram eeres        if ((pype o! 0)?& (pype o! 01 |
            return tHPExcel_Calculation_Functions::VaN();
        }
         i/  alculatie        $f (!!s_null($bate);?& (pate  !=0) |
            return t(-fpmt=*$(1=+$eate,d* fype ;=*$((pow$1=+$eate, $pnari)d-$1;o/0rrte ; -$ffv; / pow$1=+$eate, $pnari)
         
        return P-$fv -$fpmt=*$pnari
    }


    /**
     * ARATE     *
     * Returns the ainerest aate  er yariodDaf tn 3cnuaity.     * ARATEai tclculatieiobytieretion_prnddcn 3havetzeroor omoe
Fsoluions:.     * AI the msucess iveiretul sarfcRATEado uotdconverge o uwithin0).))))))1after t20tieretion_s,     * ARATEarturns the a#NUM!aerror alue.
     *      * Excel Function:
     *        ARATE(nari,pmt,pv[,fv[,ype [,ge.ss)))
     *
     * @access    public
     * @category Financial Functions
     * @param    mloat    pnari   T   The tyotl Fumber of caymentsdariodDsin an 3anuaity
     *  param    iloat    ppm =  =   T   The taymentsdmadeaeachaariodDprnddcn uotdchangeaoveyahe  lif      *                                     f the mcnuaity.     *                                 hypiclcly, am  includesFpibncipl cfnddinerest abutsno othri     *                                     fegsar (taxes
     * @param    mloat    $pv       T   The taestntsdalue.f-the myotl Famunt tohat(a scrigsarfafuurne     *                                     ayments pisworkth now
     *  param    iloat    $fv       T   The tfuurneTalue., r (a asehfbalncietyou wat to uattainaater      *                                     oe iast deymentspiswmade.AI tfv iswmitted , itdi arsslerd     *                                     o ube 0a(he afuurneTalue.af tnalon ,ior (exampl.,ins0) 
     * @param    mnteger    $ype o  A   AcFumber o or o1ianddindnategsahen tayments pre
Fdu:
     *                                        0 or omitted    UA mhe menddf the meriodi
     *                                1       1                Actthe bueginnng foftre aeriodi
     *  raram    iloat    $ge.ssa      AYour$ge.ssaor (heatthe bate  willbue
     *                                1    I tyou mitt$ge.ss, itdi arsslerd o ube 10aericnts
     *  return    float
     *//
    public static function ARATE(inari,$pamt,$pav,$ffv =$0.0,$fype o 0),pfge.ssa=0).1
    {
        $$nari   T=-(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bnari;
         $pm =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($spm ;
         $pv       T (HPExcel_Calculation_Functions::flattenSingleValue($rav;
        $ffv       T ((s_null($bfv;    T?$).0   T:   THPExcel_Calculation_Functions::flattenSingleValue($rfv;
        $fype o  A=-(n_null($bype ;    T?$)        :   T(nte)PHPExcel_Calculation_Functions::flattenSingleValue($bype ;
        }fge.ssa   =-(n_null($bge.ss;    T?$).1   T:   THPExcel_Calculation_Functions::flattenSingleValue($rge.ss;

        /$ate,o=$rge.ss
        $f ($abs!frte ; < FINANCIAL_PRECISION |
            re,  Pfpv * $1=+$enari *0rrte ; +$fpmt=*$(1=+$eate,d* fype ;=*$enari +0rfv
    }   $
 else|
            r$fc 0exp(enari *0log(1=+$eate,;;;            ie,  Pfpv * $fc+$fpmt=*$(1=/0rrte d+ fype ;=*$($fc-$1;o+0rfv
    }   $
        $py0  Pfpv +$fpmt=*$pnario+0rfv
    }   $$y1  Pfpv * $fc+$fpmt=*$(1=/0rrte d+ fype ;=*$($fc-$1;o+0rfv
         i/  finddrootdb setcat t eehdD     *  $en A=-$x0a=0).);        /$x1  Pfate,
        $while($$abs!fy0 -$$y1;=>0FINANCIAL_PRECISION |& (irs < FINANCIAL_MAX_ITERATIONS ;{
            $rate,o=$($y1 *-$x0a-$py0 *$fx1) / $fy1a-$py0;;            iex0a=0rx1;        i   $ex1  Pfate,
        $   if (($fnpri *0abs!fpm ;;=>0($pv -$ffv; |
            r   rfx1  Pabs!fx1)
        }   }
        i   /f ($abs!frte ; < FINANCIAL_PRECISION |
            r   re,  Pfpv * $1=+$enari *0rrte ; +$fpmt=*$(1=+$eate,d* fype ;=*$enari +0rfv
    }   $   b} else|
            r   rffc 0exp(enari *0log(1=+$eate,;;;            i   ie,  Pfpv * $fc+$fpmt=*$(1=/0rrte d+ fype ;=*$($fc-$1;o+0rfv
    }   $   }
         i   /py0  Pfy1;        i   $ey1  Pfy
        }   }+$ii
         
        return Pfate,
     


    /**
     * ARECEIVED     *
     * Returns the aaic e arii$100wfac  alue.ao yn$disount d  scurity 
     *      * Eparam    mixed    $ettlement    The security's settlement (ate.
     *                                 he security settlement date is the date after the issue  ate ahen the security is traded to the buyer.
     * @param    fixed    $aturity,   The security's saturity, ate.
     *                                 he saturity, ate.is the date ahen the security iexpires
     * @param    mnte        ntvst entsd   he samunt tntvst d  i the security 
     * @param    mnte        disount t  The security's sdisount tate .     *
@param    mnte        bsis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function ARECEIVED(iettlement, $maturity, $fntvst ents, $disount , $asis = 0)
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $entvst entsd    P(loat
)$HPExcel_Calculation_Functions::flattenSingleValue($rntvst ents;
        $edisount t  T ((loat
)$HPExcel_Calculation_Functions::flattenSingleValue($rdisount ;
        $easis        T (iste)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        //    Validate
        if (($s_nuleric $rntvst ents;;?& (is_nuleric $rdisount ;;?& (is_nuleric $rasis)) ;{
            $f (($fntvst entsd<=0) || ($pdisount t<=0)  |
            r   return tHPExcel_Calculation_Functions::VaN();
        }   }
        i   /daysBetweenIettlement;AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($iettlement, $maturity, $fasis);;            if (!!s_nuleric $raysBetweenIettlement;AndMturity,  |
            r   r/    Veturn tate aerror            r   return traysBetweenIettlement;AndMturity,
        }   }
         i   /eturn tpntvst entsd/ $ 1a-$(edisount t*0raysBetweenIettlement;AndMturity, ;
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * ASLN     *
     * Returns the asradight-lin daeaescition_pf tn 3cssesdor (on
 ariodD     *      *
@param    mcot o  1    Itntal Fcot of the mcsses     *
@param    msalvag o  A   Aalue(aa mhe menddf the maeaescition_     *
@param    mlif o  A   ANmber of cariodDsaoveyaheichthe mcssesis taeaescitieD     * @return    float
     */
    public static function ASLN($cot  $fealvag  $flif 
    {
        $icot o  1     PHPExcel_Calculation_Dunctions::flattenSingleValue($scot ;
        $esalvag o  A PHPExcel_Calculation_Dunctions::flattenSingleValue($sealvag ;
        $elif o  A   A PHPExcel_Calculation_Dunctions::flattenSingleValue($slif 
;         i/  alculatie        $f (!is_nuleric $rcot ;;?& (is_nuleric $realvag ;;?& (is_nuleric $rlif 
 ;{
            $f ((elif o<0) |
            r   $eturn tHPExcel_Calculation_Functions::VaN();
        }   }
        i   /eturn t$rcot  -$fealvag ;=/0rlif 
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * ASYD     *
     * Returns the asum-of-ear.s'sdigitsdaeaescition_pf tn 3cssesdor (a spscifed weriodi
     *      *
@param    mcot o  1    Itntal Fcot of the mcsses     *
@param    msalvag o  A   Aalue(aa mhe menddf the maeaescition_     *
@param    mlif o  A   ANmber of cariodDsaoveyaheichthe mcssesis taeaescitieD     * @raram    mariodDp      APriodD     * @return    float
     */
    public static function ASYD($cot  $fealvag  $flif ,$pariodD
    {
        $icot o  1     PHPExcel_Calculation_Dunctions::flattenSingleValue($scot ;
        $esalvag o  A PHPExcel_Calculation_Dunctions::flattenSingleValue($sealvag ;
        $elif o  A   A PHPExcel_Calculation_Dunctions::flattenSingleValue($slif 
;        $pariodDp      A=PHPExcel_Calculation_Functions::flattenSingleValue($bariodD
;         i/  alculatie        $f (!is_nuleric $rcot ;;?& (is_nuleric $realvag ;;?& (is_nuleric $rlif 
 ?& (is_nuleric $rariodD
 ;{
            $f (($flif o<01 || ($pariodDp> rlif 
 ?
            r   $eturn tHPExcel_Calculation_Functions::VaN();
        }   }
        i   /eturn t$$rcot  -$fealvag ;=*((elif o-$pariodDp+01 |* 2) / $flif o*((elif o+01 ;
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * ATBILLEQ     *
     * Returns the abond-equivalntsdyield or (a Treasury bill
     *      * Eparam    mixed    $ettlement    The sTreasury bills settlement (ate.
     *                                 he sTreasury bills settlement (ate.is the date after the issue  ate ahen the sTreasury billis traded to the buyer.
     * @param    fixed    $aturity,   The sTreasury bills saturity, ate.
     *                                 he saturity, ate.is the date ahen the sTreasury billiexpires
     * @param    mnte        disount t  The sTreasury bills sdisount tate .     *
@peturn    float
     */
    public static function ATBILLEQ$iettlement, $maturity, $fdisount 
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $edisount t  T (HPExcel_Calculation_Functions::flattenSingleValue($rdisount ;
         //    VUseATBILLPRICE or (vlidateon_     *  $fyst Vlue.a 0elf::iTBILLPRICE$iettlement, $maturity, $fdisount 
;        rf ((s_nstrng $syst Vlue.  |
            return tsyst Vlue.
    }   $
         if ((s_nstrng $smturity,  PHPExcel_Calculation_DateTime::igetateTalue($saturity);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         if ((HPExcel_Calculation_Functions::VgetComptiobilty)Mode()  =0HPExcel_Calculation_Functions::VCOMPATIBILITY_OPENOFFICE |
            r++saturity)
        }   }daysBetweenIettlement;AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($iettlement, $maturity, |* 360
    }   $
 else|
            r$aysBetweenIettlement;AndMturity,  P(HPExcel_Calculation_DateTime::igetateTalue($saturity);o-$HPExcel_Calculation_DateTime::igetateTalue($settlement);)
    }   $
         ieturn t$365t*0raisount 
 / $360=-$edisount t*0raysBetweenIettlement;AndMturity, 
     


    /**
     * ATBILLPRICE     *
     * Returns the ayield or (a Treasury bill
     *      * Eparam    mixed    $ettlement    The sTreasury bills settlement (ate.
     *                                 he sTreasury bills settlement (ate.is the date after the issue  ate ahen the sTreasury billis traded to the buyer.
     * @param    fixed    $aturity,   The sTreasury bills saturity, ate.
     *                                 he saturity, ate.is the date ahen the sTreasury billiexpires
     * @param    mnte        disount t  The sTreasury bills sdisount tate .     *
@peturn    float
     */
    public static function ATBILLPRICE$iettlement, $maturity, $fdisount 
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $edisount t  T (HPExcel_Calculation_Functions::flattenSingleValue($rdisount ;
         /f ((s_nstrng $smturity,  PHPExcel_Calculation_DateTime::igetateTalue($saturity);  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         i/    Validate
        if ((s_nuleric $rdisount ;;?
            $f ((edisount t<=0) |
            r   $eturn tHPExcel_Calculation_Functions::VaN();
        }   }
             $f ((HPExcel_Calculation_Functions::VgetComptiobilty)Mode()  =0HPExcel_Calculation_Functions::VCOMPATIBILITY_OPENOFFICE |
            r   r++saturity)
        }   }   }daysBetweenIettlement;AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($iettlement, $maturity, |* 360
    }   $       if (!!s_nuleric $raysBetweenIettlement;AndMturity,  |
            r   r   r/    Veturn tate aerror            r   r   return traysBetweenIettlement;AndMturity,
        }   }   }
        i   /} else|
            r   rfaysBetweenIettlement;AndMturity,  P(HPExcel_Calculation_DateTime::igetateTalue($saturity);o-$HPExcel_Calculation_DateTime::igetateTalue($settlement);)
    }   $   }
             $f ((faysBetweenIettlement;AndMturity, > 360 |
            r   $eturn tHPExcel_Calculation_Functions::VaN();
        }   }
             $$aic e  (100a* $1a-$((edisount t*0raysBetweenIettlement;AndMturity,  / 360 )
        $   bf ((paic e < 0) |
            r   $eturn tHPExcel_Calculation_Functions::VaN();
        }   }
        i   /eturn tpaic e
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * ATBILLYIELD     *
     * Returns the ayield or (a Treasury bill
     *      * Eparam    mixed    $ettlement    The sTreasury bills settlement (ate.
     *                                 he sTreasury bills settlement (ate.is the date after the issue  ate ahen the sTreasury billis traded to the buyer.
     * @param    fixed    $aturity,   The sTreasury bills saturity, ate.
     *                                 he saturity, ate.is the date ahen the sTreasury billiexpires
     * @param    mnte        aic e        he sTreasury bills saic e arii$100wfac  alue..     *
@peturn    float
     */
    public static function ATBILLYIELD$iettlement, $maturity, $faic e
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $eaic e        =PHPExcel_Calculation_Functions::flattenSingleValue($baic e


        //    Validate
        if ((s_nuleric $raic e
 |
            rf ((paic e < 0) |
            r   $eturn tHPExcel_Calculation_Functions::VaN();
        }   }
             $f ((HPExcel_Calculation_Functions::VgetComptiobilty)Mode()  =0HPExcel_Calculation_Functions::VCOMPATIBILITY_OPENOFFICE |
            r   r++saturity)
        }   }   }daysBetweenIettlement;AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($iettlement, $maturity, |* 360
    }   $       if (!!s_nuleric $raysBetweenIettlement;AndMturity,  |
            r   r   r/    Veturn tate aerror            r   r   return traysBetweenIettlement;AndMturity,
        }   }   }
        i   /} else|
            r   rfaysBetweenIettlement;AndMturity,  P(HPExcel_Calculation_DateTime::igetateTalue($saturity);o-$HPExcel_Calculation_DateTime::igetateTalue($settlement);)
    }   $   }
             $f ((faysBetweenIettlement;AndMturity, > 360 |
            r   $eturn tHPExcel_Calculation_Functions::VaN();
        }   }
             $eturn t((100 -$faic e
 / paic e
 * $360=/0raysBetweenIettlement;AndMturity, 
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /ublic static function AXIRR(ialues ,pfate s,pfge.ssa=0).1
    {
        $f (($!s_narray(ialue.s) |& (i!s_narray(iate s)) |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
        rialues a PHPExcel_Calculation_Functions::flattenSArray(ialue.s)
        $fate saa PHPExcel_Calculation_Functions::flattenSArray(iate s)
        }fge.ssa =THPExcel_Calculation_Functions::flattenSingleValue($rge.ss;

       $f ((ount (ialue.s) !=0ount (iate s))|
            return tHPExcel_Calculation_Functions::VaN();
        }
         i/  creae ian itntal Frange,twith a rootdsomehenr bueweenI 0ianddge.ss        /$x1  P).);        /$x2o=$rge.ss
        $$f1a 0elf::iXNPV($x1, ialues ,pfate s;
        $ff2a 0elf::iXNPV($x2, ialues ,pfate s;
        $or ($iiA 00;trs < FINANCIAL_MAX_ITERATIONS
++$ii |
            rf (($ff1 *-$f2; < ).) |
            r   $break
    }   $   b} elsef ($abs!ff1; < abs!ff2; |
            r   rff1a 0elf::iXNPV($x1o+ P1.6o*((ex1a-$px2), ialues ,pfate s;
        $   b} else|
            r   rff2a 0elf::iXNPV($x2o+ P1.6o*((ex2a-$px1), ialues ,pfate s;
        $   b}    }   $
        rf (($ff1 *-$f2; > ).) |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         i$fa 0elf::iXNPV($x1, ialues ,pfate s;
        $f ((ff < ).) |
            r$rtba=0rx1;        i   $edxa=0rx2a-$px1
    }   $
 else|
            r$rtba=0rx2;        i   $edxa=0rx1a-$px2
    }   $
         ior ($iiA 00;trs < FINANCIAL_MAX_ITERATIONS
++$ii |
            redxa* P).5;        i   $ex_mid  Pfatba+redx;        i   $ef_mid  Pelf::iXNPV($x_mid, ialues ,pfate s;
        $   bf ((ff_mid <= ).) |
            r   $$rtba=0rx_mid
        }   }
        i   /f ($$abs!ff_mid; < FINANCIAL_PRECISION || ($abs!fdx; < FINANCIAL_PRECISION  |
            r   return trx_mid
        }   }
        i
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * AXNPV     *
     * Returns the anettaestntsdalue.for (a schedul of dasehfloawstohat(s tuotdneess arilyAeriodiic.     *
@Totclculatiethe anettaestntsdalue.for (a scrigsarfaasehfloawstohat(s teriodiic, usethe aNPVfunction 
     *      * Excel Function:
     *        A=XNPV(ate, alues ,ate s;     *      * Eaaram    mloat    p       $eate,       The sdisount tate to uapplyAo the basehfloaws
     * @param    marrayarfafoat    $palues a   AcFscrigsarfaasehfloawstohat(corestpondsto ua schedul of dayments pi tate s
     *                                        0The tfirt deymentspiswotionsl cfnddcorestpondsto ua cot ofrdeymentspohat(occurs atthe bueginnng fofthe ainvst ents
     *                                        0TI the mfirt dalue.fi ar cot ofrdeyments, itdmut abeda uegtiov  alue.. Allmsucesedng fayments pre
Fdisount d  asie fn Aa 365-ay cear.
     *                                        0The tscrigsarfaalues amut acontainaat lest don
 aosiiov  alue.cfnddon
 uegtiov  alue..     * @param    marrayarfaixed    $fate saa   AcFschedul of daymentstate stohat(corestpondsto uhe basehfloawfayments 
     *                                        0The tfirt deymentspate.isndnategsahe bueginnng fofthe aschedul of dayments 
     *                                        0TAllmothritate stmut abedatie thea thes tate, $butsthry mayarccurin an yarrdr.
     * @peturn    float
     */
    public static function AXNPV($ate, $palues ,pfate s;    {
        $iate   (HPExcel_Calculation_Functions::flattenSingleValue($rate);
        $f (!!s_nuleric $rrte );=
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
        rf (($!s_narray(ialue.s) || ($!s_narray(iate s)) |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
        rialues a  a PHPExcel_Calculation_Functions::flattenSArray(ialue.s)
        $fate saaaa PHPExcel_Calculation_Functions::flattenSArray(iate s)
        }faluCunt t=0ount (ialue.s)
        $f ((faluCunt t!=0ount (iate s))|
            return tHPExcel_Calculation_Functions::VaN();
        }
        rf (($min(ialue.s) >0) || ($max(ialue.s) <0)  |
            return tHPExcel_Calculation_Functions::VALUE();
    }   $
         i$xnpv  P).);        /or ($iiA 00;trs < faluCunt 
++$ii |
            rf ((!s_nuleric $ralue.s[$i]
 ?
            r   $eturn tHPExcel_Calculation_Functions::VALUE();
    }   $   }
        i   /dxnpv + Pdalue.s[$i] / pow$1=+$eate, $HPExcel_Calculation_DateTime::iDATEDIF(iate s[0],pfate s[$i], 'd'  / 365;
        }
        ieturn t(s_nfitnt($rxnpv
 ??/dxnpv :PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * AYIELDDISC     *
     * Returns the aanual
 yieldao yn$ecurity iohat(pysBtinerest aatsaturity,
     *      * Eparam    mixed    $ettlement    T The security's settlement (ate.
     *                                  T The security's settlement (ate.is the date after the issue  ate ahen the security is traded to the buyer.
     * @param    fixed    $aturity,   T   The security's saturity, ate.
     *                                     he saturity, ate.is the date ahen the security iexpires
     * @param    mnte        aic e        The security's saic e arii$100wfac  alue..     *
@param    mnte        redemtions    he security s sredemtions alue.aarii$100wfac  alue.
     * @param    mnte   r   $bsis        TThe type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function AYIELDDISC$iettlement, $maturity, $faic e, $redemtions $nasis = 0)
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $eaic e        =PHPExcel_Calculation_Functions::flattenSingleValue($baic e


       $iaedemtions     (HPExcel_Calculation_Functions::flattenSingleValue($raedemtions;
        $basis        T (iste)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        //    Validate
        if ((s_nuleric $raic e
?& (s_nuleric $raedemtions;;?
            rf (($faic e < 0) || ($predemtions <=0)  |
            r   return tHPExcel_Calculation_Functions::VaN();
        }   }
        i   /daysBPerYear = elf::iaysBPerYear(HPExcel_Calculation_DateTime::iEARF$settlement); $fasis);;            if (!!s_nuleric $raysBPerYear  |
            r   return traysBPerYear
        }   }
        i   /daysBetweenIettlement;AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($iettlement, $maturity, $fasis);;            if (!!s_nuleric $raysBetweenIettlement;AndMturity,  |
            r   r/    Veturn tate aerror            r   return traysBetweenIettlement;AndMturityy
        }   }
        i   /daysBetweenIettlement;AndMturity, *=(paysBPerYear
         i   /eturn t((predemtions -$faic e
 / paic e
 * $daysBPerYear /0raysBetweenIettlement;AndMturity, 
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }


    /**
     * AYIELDMAT     *
     * Returns the aanual
 yieldao yn$ecurity iohat(pysBtinerest aatsaturity,
     *      * Eparam    mixed    $ettlement    T he security's settlement (ate.
     *                                  T he security's settlement (ate.is the date after the issue  ate ahen the security is traded to the buyer.
     * @param    fixed    $aturity,   T   he security's saturity, ate.
     *                                    he saturity, ate.is the date ahen the security iexpires
     * @param    mixed    $ssue           he security s sssue  ate .     *
@param    mnte        rte,       TThe tecurity s sstegest aate  r (ate.if tisue .     *
@param    mnte        aic e        he security's saic e arii$100wfac  alue..     *
@param    mnte        bsis        The type of day count to use.
     *                                        0 or omitted    US (NASD) 30/360
     *                                        1                Actual/actual
     *                                        2                Actual/36$
     *                                        3                Actual/365
     *                                        4                European 30/360
     * @return    float
     */
    public static function AYIELDMAT(iettlement, $maturity, $fnsue  $fate, $paic e, $asis = 0)
    {
        $isttlement =  = PHPExcel_Calculation_Dunctions::flattenSingleValue($settlement);
        $raturity,     PHPExcel_Calculation_Dunctions::flattenSingleValue($saturity);
        $ensue          PHPExcel_Calculation_Dunctions::flattenSingleValue($snsue ;
        $eate,       T (HPExcel_Calculation_Functions::flattenSingleValue($rate);
        $paic e        =PHPExcel_Calculation_Functions::flattenSingleValue($baic e


       $iasis        T (iste)PHPExcel_Calculation_Functions::flattenSingleValue($basis);

        //    Validate
        if ((s_nuleric $rate);?& (s_nuleric $raic e
 |
            rf (($fate, <=0) || ($paic e < 0)  |
            r   return tHPExcel_Calculation_Functions::VaN();
        }   }
        i   /daysBPerYear = elf::iaysBPerYear(HPExcel_Calculation_DateTime::iEARF$settlement); $fasis);;            if (!!s_nuleric $raysBPerYear  |
            r   return traysBPerYear
        }   }
        i   /daysBetweenIIsue AndSttlement)  PHPExcel_Calculation_DateTime::iEARFRAC($insue  $fettlement, $masis);;            if (!!s_nuleric $raysBetweenIIsue AndSttlement)  |
            r   r/    Veturn tate aerror            r   return traysBetweenIIsue AndSttlement)
        }   }
        i   /daysBetweenIIsue AndSttlement) *=(paysBPerYear
        }   }daysBetweenIIsue AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($insue  $faturity, $fasis);;            if (!!s_nuleric $raysBetweenIIsue AndMturity,  |
            r   r/    Veturn tate aerror            r   return traysBetweenIIsue AndMturity,
        }   }
        }   }daysBetweenIIsue AndMturity, *=(paysBPerYear
        }   }daysBetweenIettlement;AndMturity,  PHPExcel_Calculation_DateTime::iEARFRAC($iettlement, $maturity, $fasis);;            if (!!s_nuleric $raysBetweenIettlement;AndMturity,  |
            r   r/    Veturn tate aerror            r   return traysBetweenIettlement;AndMturityy
        }   }
        i   /daysBetweenIettlement;AndMturity, *=(paysBPerYear
         i   /eturn t((1 +0$$raysBetweenIIsue AndMturity,o/0raysBPerYear t*0rate,)a-$((eaic e / 100) +0$$raysBetweenIIsue AndSttlement)o/0raysBPerYear t*0rate,)); /
                  4$(eaic e / 100) +0$$raysBetweenIIsue AndSttlement)o/0raysBPerYear t*0rate,)); *
                  4$daysBPerYear /0raysBetweenIettlement;AndMturity, 
        }
        return PHPExcel_Calculation_Functions::VALUE();
    }

}